<?php
require_once __DIR__ . '/../../core/Auth.php';
require_once __DIR__ . '/../../app/models/NotificationModel.php';

class NotificationController {
    private $model;

    public function __construct() {
        $this->model = new NotificationModel();
    }

    public function list() {
        Auth::checkRole(['Super Admin', 'Admin', 'Teacher', 'Student', 'Parent', 'Accountant']);
        $user = Auth::user();
        $notifications = $this->model->getAll($user['id']);
        require_once __DIR__ . '/../views/notifications/list.php';
    }

    public function markRead($id) {
        $this->model->markAsRead($id);
        header("Location: /sms/public/notification/list");
        exit;
    }

    // API endpoint for AJAX notification count
    public function count() {
        header('Content-Type: application/json');
        Auth::checkRole(['Super Admin', 'Admin', 'Teacher', 'Student', 'Parent', 'Accountant']);
        $user = Auth::user();
        echo json_encode(['count' => $this->model->getUnreadCount($user['id'])]);
        exit;
    }
}