<?php
require_once __DIR__ . '/../../core/Auth.php';
require_once __DIR__ . '/../../app/models/ExamModel.php';
require_once __DIR__ . '/../../app/helpers/SessionHelper.php';

class ExamController {
    private $model;

    public function __construct() {
        Auth::checkRole(['Super Admin', 'Admin', 'Teacher']);
        $this->model = new ExamModel();
    }

    public function index() {
        $exams = $this->model->getAll();
        require_once __DIR__ . '/../views/exams/index.php';
    }

    public function create() {
        require_once __DIR__ . '/../views/exams/create.php';
    }

    public function store() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            Auth::validateCsrf($_POST['csrf_token']);
            $data = [
                'name' => $_POST['name'],
                'year' => $_POST['year'],
                'term' => $_POST['term']
            ];
            if ($this->model->create($data)) {
                SessionHelper::setFlash('exam_msg', 'Exam created successfully!', 'success');
            }
            header("Location: /sms/public/exam/index");
            exit;
        }
    }
}