<?php
/**
 * Class Controller
 * Handles all class-related operations
 */
require_once __DIR__ . '/../../core/Auth.php';
require_once __DIR__ . '/../../core/Controller.php';
require_once __DIR__ . '/../../app/models/ClassModel.php';
require_once __DIR__ . '/../../app/helpers/SessionHelper.php';

class ClassController extends Controller {
    private $model;

    public function __construct() {
        Auth::checkRole(['Super Admin', 'Admin']);
        $this->model = new ClassModel();
    }

    public function index() {
        $classes = $this->model->getAll();
        require_once __DIR__ . '/../views/classes/index.php';
    }

    public function create() {
        require_once __DIR__ . '/../views/classes/create.php';
    }

    public function store() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            Auth::validateCsrf($_POST['csrf_token']);
            
            $errors = $this->validate($_POST, [
                'name' => 'required|max:50',
                'section' => 'required|max:10'
            ]);

            if (!empty($errors)) {
                SessionHelper::setFlash('class_errors', $errors);
                header("Location: /sms/public/class/create");
                exit;
            }

            if ($this->model->create($_POST['name'], $_POST['section'])) {
                SessionHelper::setFlash('class_msg', 'Class created successfully!', 'success');
            } else {
                SessionHelper::setFlash('class_msg', 'Failed to create class.', 'danger');
            }
            header("Location: /sms/public/class/index");
            exit;
        }
    }

    public function edit($id) {
        $class = $this->model->getById($id);
        if (!$class) {
            SessionHelper::setFlash('class_msg', 'Class not found.', 'danger');
            header("Location: /sms/public/class/index");
            exit;
        }
        require_once __DIR__ . '/../views/classes/edit.php';
    }

    public function update($id) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            Auth::validateCsrf($_POST['csrf_token']);
            
            $errors = $this->validate($_POST, [
                'name' => 'required|max:50',
                'section' => 'required|max:10'
            ]);

            if (!empty($errors)) {
                SessionHelper::setFlash('class_errors', $errors);
                header("Location: /sms/public/class/edit/" . $id);
                exit;
            }

            if ($this->model->update($id, $_POST['name'], $_POST['section'])) {
                SessionHelper::setFlash('class_msg', 'Class updated successfully!', 'success');
            } else {
                SessionHelper::setFlash('class_msg', 'Failed to update class.', 'danger');
            }
            header("Location: /sms/public/class/index");
            exit;
        }
    }

    public function delete($id) {
        if ($this->model->delete($id)) {
            SessionHelper::setFlash('class_msg', 'Class deleted successfully!', 'success');
        } else {
            SessionHelper::setFlash('class_msg', 'Failed to delete class.', 'danger');
        }
        header("Location: /sms/public/class/index");
        exit;
    }
}